﻿//////////////////////////////////////////////
// FilmGrainEffect.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class System ;
}

namespace nkGraphics
{
	class Program ;
	class Texture ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

#include "../Effect.h"

#include "FilmGrainEffectInfo.h"

/// Class ------------------------------------

namespace nkAstraeus
{
	class DLL_ASTRAEUS_EXPORT FilmGrainEffect final : public Effect
	{
		public :

			// Constructor, destructor
			FilmGrainEffect (System* system) noexcept ;
			virtual ~FilmGrainEffect () ;

			// Getters
			nkGraphics::Texture* getSourceTexture () const ;
			float getStrength () const ;
			bool getRgbNoise () const ;
			bool getBlendGrainInTarget () const ;

			// Setters
			void setSourceTexture (nkGraphics::Texture* value) ;
			void setStrength (float value) ;
			void setRgbNoise (bool value) ;
			void setBlendGrainInTarget (bool value) ;

			// Load
			virtual bool load () override ;
			virtual void unload () override ;

		public :

			// Statics
			static nkMemory::UniquePtr<FilmGrainEffect> create (System* system = nullptr) ;

		private :

			// Functions
			// Program
			bool _prepareProgram () ;

			// Shader
			bool _prepareShader () ;

		private :

			// Attributes
			System* _system ;

			// Program
			nkGraphics::Program* _program ;
			FilmGrainEffectInfo _programInfo ;

			// Info
			FilmGrainEffectInfo _info ;
	} ;
}